--[[---------------------------------------------------------------------------
	Chocolatier Two Player Selection Dialog
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local selectedPlayer = GetCurrentUser()
local kMaxUsers = 10
local xLeft = kCenter - ui.devButtonW/2
local xRight = kCenter + ui.devButtonW/2

-------------------------------------------------------------------------------

local function UpdateButtons()
	-- Update player names
	for i=1,kMaxUsers do
		if i <= GetNumUsers() then
			EnableWindow("player"..tostring(i), true)
			SetLabel("player"..tostring(i), GetUserName(i-1))
			SetButtonToggleState("player"..tostring(i), false)
		else
			EnableWindow("player"..tostring(i), false)
		end
	end

	-- Make sure selection is valid
	if selectedPlayer >= GetNumUsers() then
		selectedPlayer = GetNumUsers() - 1
	end
	if GetNumUsers() > 0 then
		SetButtonToggleState("player"..tostring(selectedPlayer+1), true)
	end
	
	-- Set up buttons
	if GetNumUsers() == 0 then
		EnableWindow("ok", false)
		EnableWindow("edit", false)
		EnableWindow("delete", false)
		EnableWindow("newuser", true)
	elseif GetNumUsers() == kMaxUsers then
		EnableWindow("ok", true)
		EnableWindow("edit", true)
		EnableWindow("delete", true)
		EnableWindow("newuser", false)
	else
		EnableWindow("ok", true)
		EnableWindow("edit", true)
		EnableWindow("delete", true)
		EnableWindow("newuser", true)
	end
end

-------------------------------------------------------------------------------

local function NewPlayer()
	local name = DoModal("ui/entername.lua")
	if name and name ~= "" then
		CreateNewUser(name)
		selectedPlayer = GetNumUsers() - 1
		UpdateButtons()
	end
end

local function DeletePlayer(n)
	n = n or selectedPlayer
	local yn = DisplayDialog { "ui/yndialog.lua", body="#"..GetString("opt_confirmdelete", GetUserName(n)) }
	if yn == "yes" then
		DeleteUser(n)
		UpdateButtons()
	end
end

local function EditPlayer(n)
	n = n or selectedPlayer
	local name = GetUserName(n)
	name = DisplayDialog { "ui/entername.lua", name=name }
	if name and name ~= "" then
		SetUserName(n, name)
		UpdateButtons()
	end
end

local function CloseDialog()
	SetCurrentUser(selectedPlayer)
	gSim = nil
	CloseWindow()
end

-------------------------------------------------------------------------------

local function PlayerButtons(y)
	local h = 30
	local t = { BeginGroup() }
	for i=1,kMaxUsers do
		local itemp = i-1
		table.insert(t, TextButton { x=kCenter,y=y, type=kRadio, name="player"..tostring(i), label="",
			font=dialogFont,
			graphics = { nil, "control/name_entry_field", "control/name_entry_field" },
			command=function()
				selectedPlayer = itemp
				UpdateButtons()
			end })
		y = y + h
	end
	return Group(t)
end

-- The dialog itself
MakeDialog
{
	name="chooseplayer",
	Frame
	{
		x=kCenter,y=kCenter,w=400,h=440, fit=true,color=DialogColor,
		
		Text { x=0,y=0,w=kMax,h=40, label="choose_player_header", },

		PlayerButtons(40),
		
		TextButton { x=xLeft,y=360, name="newuser", label="opt_newplayer", command=NewPlayer },
		TextButton { x=xLeft,y=400, name="delete", label="opt_deleteplayer", command=DeletePlayer },
		TextButton { x=xRight,y=360, name="edit", label="opt_editplayer", command=EditPlayer },
		TextButton { x=xRight,y=400, name="ok", label="ok", command=CloseDialog, default=true },
	},
}

UpdateButtons()
